/*
 *  kexbases\kernel32\Debug.c
 *
 *  Copyright (C) 2006-2008, Xeno86
 *  Copyright (C) 2019, jumper
 *
 *  This file is part of KernelEx source code.
 *
 *  KernelEx is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published
 *  by the Free Software Foundation; version 2 of the License.
 *
 *  KernelEx is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */

//#define _WIN32_WINDOWS 0x0410
//#define ENABLE_FILEAPIS
#include "common.h"
//#include <tlhelp32.h>
#include "_kernel32_apilist.h"

typedef LONG NTSTATUS;
extern NTSTATUS warn (char *pCaption, char *pMessage);
extern "C" __declspec(dllimport) int hConsole;

#define WM_KEXAPPENDLOG 0x6eef

/*
dprintf
_DebugPrintf
_DebugOut
*/

// MAKE_EXPORT OutputDebugStringAW_stub=OutputDebugStringA
// MAKE_EXPORT OutputDebugStringAW_stub=OutputDebugStringW
void WINAPI OutputDebugStringAW_stub (LPSTR str)
{
}


// MAKE_EXPORT OutputDebugStringA_new=OutputDebugStringA
void WINAPI OutputDebugStringA_new (LPSTR str)
{
  static char sz1k[1024];
  wsprintf (sz1k, "%s", str); // copy 1k max
  SendMessage ((HWND)hConsole, WM_KEXAPPENDLOG, 0, (LPARAM) sz1k);
  OutputDebugStringA (str);
  warn ("KernelEx - Kernel32.OutputDebugString", str);
}


// MAKE_EXPORT OutputDebugStringW_new=OutputDebugStringW
void WINAPI OutputDebugStringW_new (LPCWSTR strW)
{
  ALLOC_WtoA(str);
  OutputDebugStringA_new (strA);
}


// MAKE_EXPORT DebugBreak_stub=DebugBreak
void DebugBreak_stub (void)
{
}


// MAKE_EXPORT DebugBreak_new=DebugBreak
void DebugBreak_new (void)
{
  //warn ("KernelEx - Kernel32.DebugBreak", "<stack trace will go here>");

  switch (MessageBox (NULL, "Abort application, Retry in debugger, or Ignore breakpoint?\n\n"
                            "(Now is a good time to start Dr.Watson or attach to this process with your favorite debugger.)",
                            "KernelEx - DebugBreak",
                            MB_ABORTRETRYIGNORE | MB_DEFBUTTON3 |
                            MB_ICONQUESTION | MB_TASKMODAL)) {
  case IDABORT:
    ExitProcess (0);
  case IDRETRY:
    _asm int 3;
  }

  //return;
}


// MAKE*EXPORT DebugBreakProcess=DebugBreakProcess_xp
BOOL DebugBreakProcess_xp (HANDLE Process)
{
  return FALSE;
}


// MAKE_EXPORT IsDebuggerPresent_no=IsDebuggerPresent
BOOL IsDebuggerPresent_no (void)
{
  return FALSE;
}


// MAKE_EXPORT IsDebuggerPresent_yes=IsDebuggerPresent
BOOL IsDebuggerPresent_yes (void)
{
  return TRUE;
}



